﻿#################
# SBS 2008/2011 Standard Event Log Alert Cleanup Utility
# by Damian Leibaschoff (damianl@microsoft.com) and Justin Crosby (jcrosby@microsoft.com)
# 
# http://blogs.technet.com/b/sbs
# 1/2012
#
# The sample scripts are not supported under any Microsoft standard support 
# program or service. The sample scripts are provided AS IS without warranty 
# of any kind. Microsoft further disclaims all implied warranties including, without 
# limitation, any implied warranties of merchantability or of fitness for a particular 
# purpose. The entire risk arising out of the use or performance of the sample scripts 
# and documentation remains with you. In no event shall Microsoft, its authors, or 
# anyone else involved in the creation, production, or delivery of the scripts be liable 
# for any damages whatsoever (including, without limitation, damages for loss of business 
# profits, business interruption, loss of business information, or other pecuniary loss) 
# arising out of the use of or inability to use the sample scripts or documentation, 
# even if Microsoft has been advised of the possibility of such damages
#################

Param($Action = "H",$Id)

Function IsInstalled
{
[reflection.assembly]::LoadWithPartialName("Microsoft.SqlServer.Smo") >$null
$srvr = new-object ("Microsoft.SqlServer.Management.Smo.Server") ".\SBSMonitoring"
$db = $srvr.Databases["SBSMonitoring"]
$result = $db.ExecuteWithResults("select * from sys.tables where name='EventLogExclusions'" )
if ($result.tables[0].rows.count -eq 0) 
{ 
	Return $false
} 
else {Return $true}
}

Function Usage
{
Write-Host "Usage:"
Write-Host ""
Write-Host ".`\SBSAlertsCleanup.ps1 -Action ACTION [-Id ID]"
Write-Host ""
Write-Host "Available Actions:"
Write-Host "Install or I"
Write-Host "Update the SBSMonitoring Database to support this new feature. Pre-populates a default set of excluded alerts based on the SBS version."
Write-Host ""
Write-Host "ListEvents or LE"
Write-Host "Lists events that have been collected in the SBSMonitoring database."
Write-Host ""
Write-Host "AddExcludedEvent or AX"
Write-Host "Allows you to add additional events to be excluded from the reports based on the available events listed in the ListEvents Action. Requires the use of the Id parameter."
Write-Host ""
Write-Host "ListExcludedEvents or LX"
Write-Host "Lists exclusions that have been set."
Write-Host ""
Write-Host "RemoveExcludedEvent or RX"
Write-Host "Removes an event from the list of exclusions. Requires the use of the Id parameter."
Write-Host "Events will only begin collecting again from the time this is removed."
Write-Host ""
Write-Host "Help or H"
Write-Host "This help message."
Write-Host ""
Write-Host "Examples:"
Write-Host "Install the feature with it's default set of exclusions."
Write-Host ".`\SBSAlertsCleanup.ps1 -Action Install"
### Show output
Write-Host ""
Write-Host "List events that have been collected"
Write-Host ".`\SBSAlertsCleanup.ps1 -Action ListEvents"
#### Show results
Write-Host ""
Write-Host "Exclude an Event from the ones shown by ListEvents"
Write-Host ".`\SBSAlertsCleanup.ps1 -Action AddExcludedEvent -Id 2"
#### Show results
Write-Host ""
Write-Host ""
Write-Host "For more information please check http://blogs.technet.com/b/sbs"
}

Function Get-SBSVersion
{
#Find out the OS version
$version = "Unknown"
if ($((gwmi win32_operatingsystem).version) -like "6.0*") 
{
 			$version = "2008"
} else { $version = "2011" }
return $version
}

Function Cleanup
{
[reflection.assembly]::LoadWithPartialName("Microsoft.SqlServer.Smo") >$null
$srvr = new-object ("Microsoft.SqlServer.Management.Smo.Server") ".\SBSMonitoring"
$db = $srvr.Databases["SBSMonitoring"]
$result = $db.ExecuteWithResults("Select * FROM EventLogExclusions")

	foreach ($exc in $result.tables[0]) {
		$EventId=$exc.eventid
		$SourceId=$exc.sourceid
    $result = $db.ExecuteWithResults("DELETE EventLog FROM EventLog Where EventID=$EventId and SourceID=$SourceId" )
	}

}

Function Install
{
$SBSVersion = Get-SBSVersion

if ($SBSVersion -ne "Unknown")	{
	
	#Alter SP - TODO
	sqlcmd -I -S $env:COMPUTERNAME\SBSMonitoring -i update-StoredProcedure.sql
	

	#Create Table 
	sqlcmd -I -S $env:COMPUTERNAME\SBSMonitoring -i create-exclusion-table.sql
	
	#Add default excluded events Exclusions depending on version.

	if ($SBSVersion -eq "2008")
		{
			$EventIDArray = @(10016,10009)
			$SourceArray = @("DCOM","DCOM")
		}

	if ($SBSVersion -eq "2011") 
		{
			$EventIDArray = @(129,142,4107,10016,10009,5586,6772,6398,8,6)
			$SourceArray = @("WinRM","WinRM","Microsoft-Windows-CAPI2","DCOM","DCOM","SharePoint Foundation","SharePoint Foundation","SharePoint Foundation","MSExchange CmdletLogs","MSExchange CmdletLogs")
		}
	[reflection.assembly]::LoadWithPartialName("Microsoft.SqlServer.Smo") >$null
	$srvr = new-object ("Microsoft.SqlServer.Management.Smo.Server") ".\SBSMonitoring"
	$db = $srvr.Databases["SBSMonitoring"]
	for ($i=0; $i -le $EventIDArray.Length – 1; $i++){
			$EventId=$EventIDArray[$i]
			$Source=$SourceArray[$i]
			$result = $db.ExecuteWithResults("select * from EventLogSource where Source='$source'" )
			if ($result.tables[0].rows.count -eq 0) { 
				#Source does not exist, add it
				$result = $db.ExecuteWithResults("INSERT INTO EventLogSource ([Source]) VALUES ('$Source')" )
				$result = $db.ExecuteWithResults("select * from EventLogSource where Source='$source'")
				}
			$SourceId=$result.Tables[0].rows[0].id
			$result = $db.ExecuteWithResults("SELECT * FROM EventLogExclusions WHERE EventID=$EventId and SourceID=$SourceId" )
			if ($result.tables[0].rows.count -eq 0) { 
				$result = $db.ExecuteWithResults("INSERT INTO EventLogExclusions ([EventID],[SourceID]) VALUES ($EventId,$SourceId)" )
			}
		}

	
	
	#write registry
	$date=Get-Date
	Set-ItemProperty "HKLM:\SOFTWARE\Microsoft\SmallBusinessServer\Admin" -name "SBSMonitoring-AlertsCleanUp-Update" -value "Installed on $date"

	
	#Force Cleanup
	Cleanup

	} else 
	{
		Write-Warning "Cannot determine SBS version - aborting install"
		Return
	}
Return
}

Function ListEvents
{
[reflection.assembly]::LoadWithPartialName("Microsoft.SqlServer.Smo") >$null
$srvr = new-object ("Microsoft.SqlServer.Management.Smo.Server") ".\SBSMonitoring"
$db = $srvr.Databases["SBSMonitoring"]
$result = $db.ExecuteWithResults("Select max(eventlog.id) ID,EventID Event,Source FROM EventLog JOIN EventLogSource ON SourceID = EventLogSource.ID group by eventid, Source order by eventlog.eventid")
$result.Tables | ft -AutoSize
}

Function ExcludeEvent
{
#Check ID is not empty and valid
#Find the row and extract the SourceId and EventId
#Verify they dont already exist in our exclusions.
if ($Id -eq $null) {
	Write-Host "ERROR: ID cannot be null"
	return
	}

[reflection.assembly]::LoadWithPartialName("Microsoft.SqlServer.Smo") >$null
$srvr = new-object ("Microsoft.SqlServer.Management.Smo.Server") ".\SBSMonitoring"
$db = $srvr.Databases["SBSMonitoring"]
$result = $db.ExecuteWithResults("Select EventLog.id,eventid,SourceID,Source FROM EventLog Join EventLogSource ON SourceID=EventLogSource.ID Where EventLog.ID=$ID")

if ($result.tables[0].rows.count -eq 0) { 
	Write-Host "ERROR: ID cannot be found. Please verify the ID using ListEvents"
	return
	}

foreach ($table in $result.tables) {
	foreach ($row in $table) {
		$Source=$row.Source
		$EventID=$row.EventID
		$SourceID=$row.SourceID
		}
	}

$result = $db.ExecuteWithResults("Select EventID,SourceID FROM EventLogExclusions Where EventID=$EventID and SourceID=$SourceID")
if ($result.tables[0].rows.count -eq 1) { 
	Write-Host "ERROR: Event already Excluded. Use ListExclusions to see the current list"
	return
	}

Write-Host "Adding Exclusion for Source: $Source, EventID: $EventID"
$result = $db.ExecuteWithResults("INSERT INTO EventLogExclusions(EventId,SourceID) VALUES ($EventID,$SourceID)")

cleanup

}

Function ListExclusions
{
[reflection.assembly]::LoadWithPartialName("Microsoft.SqlServer.Smo") >$null
$srvr = new-object ("Microsoft.SqlServer.Management.Smo.Server") ".\SBSMonitoring"
$db = $srvr.Databases["SBSMonitoring"]
$result = $db.ExecuteWithResults("Select EventLogExclusions.ID,EventLogExclusions.EventID Event,Source FROM EventLogExclusions JOIN EventLogSource ON SourceID = EventLogSource.ID")
$result.Tables | ft -AutoSize
}

Function RemoveExclusion
{
#Check ID is not empty and valid
if ($Id -eq $null) {
	Write-Host "ERROR: ID cannot be null"
	return
	}

[reflection.assembly]::LoadWithPartialName("Microsoft.SqlServer.Smo") >$null
$srvr = new-object ("Microsoft.SqlServer.Management.Smo.Server") ".\SBSMonitoring"
$db = $srvr.Databases["SBSMonitoring"]

$result = $db.ExecuteWithResults("Select EventLogExclusions.ID,EventLogExclusions.EventID Event,Source FROM EventLogExclusions JOIN EventLogSource ON SourceID = EventLogSource.ID Where EventLogExclusions.ID=$ID")

if ($result.tables[0].rows.count -eq 0) { 
	Write-Host "ERROR: ID cannot be found. Please verify the ID is currently excluded using ListExclusions"
	return
	}

foreach ($table in $result.tables) {
	foreach ($row in $table) {
		$Source=$row.Source
		$EventID=$row.Event
		$SourceID=$row.SourceID
		}
	}


Write-Host "Removing Exclusion for Source: $Source, EventID: $EventID"
$result = $db.ExecuteWithResults("DELETE EventLogExclusions FROM EventLogExclusions where ID=$Id")

}

Function Uninstall
{
## Verify that this wanted.
Write-Warning "If you proceed you will restore your SBSMonitoring functionality back to default"
Write-Host "Type p to proceed, any other key to cancel"
$ans = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")
if ($ans.character -ne "p") {
	Write-Host "Cancelling Uninstall"
	Return
	}
	
#Restore SP
sqlcmd -I -S $env:COMPUTERNAME\SBSMonitoring -i restore-Original-StoredProcedure.sql
# Drop Exclusions Table
sqlcmd -I -S $env:COMPUTERNAME\SBSMonitoring -i drop-Exclusion-Table.sql


Write-Warning "All critical alerts will be collected from this time and none will be ignored"
$date=Get-Date
Set-ItemProperty "HKLM:\SOFTWARE\Microsoft\SmallBusinessServer\Admin" -name "SBSMonitoring-AlertsCleanUp-Update" -value "Uninstalled on $date"

}

#Main
if (-not(IsInstalled) -and -not($Action -eq "I" -or $Action -eq "Install" -or $Action -eq "H" -or $Action -eq "Help"))
{
Write-Host "SBSAlertsCleanup has not yet been installed.  Please install using 'SBSAlertsCleanup.ps1 -Action Install' or use the Help action for more information"
Return
}
if ($Action -eq "H" -or $Action -eq "Help"){Usage}
else {if ($Action -eq "I" -or $Action -eq "Install"){Install}
else {if ($Action -eq "LE" -or $Action -eq "ListEvents"){ListEvents}
else {if ($Action -eq "XE" -or $Action -eq "AX" -or $Action -eq "ExcludeEvent" -or $Action -eq "AddExcludedEvent" -or $Action -eq "AddExclusion"){ExcludeEvent}
else {if ($Action -eq "LX" -or $Action -eq "ListExclusions" -or $Action -eq "ListExcludedEvents"){ListExclusions}
else {if ($Action -eq "RE" -or $Action -eq "RX" -or $Action -eq "RemoveExclusion" -or $Action -eq "RemoveExcludedEvent"){RemoveExclusion}
else {if ($Action -eq "U" -or $Action -eq "Uninstall"){Uninstall}
else {Usage}}}}}}}